require 'time'
require_relative '../../spec/rspec_helper'

$getDaysfromNow = Time.now + (5*24*60*60)

    def getTimeOffset
      time = Time.now
      @@timeOffset = "-05:00"
      if time.dst?
        @@timeOffset = "-04:00"
      end
      return @@timeOffset
    end

    def stage_cc_data_reqst()
      sql = <<EOF
    Insert into "VARDB"."CC_APPOINTMENT_REQUEST" (CC_APPOINTMENT_REQUEST_ID,APPOINTMENT_REQUEST_ID,TRAVEL_BURDEN,UNUSUAL_TRAVEL_BURDEN,DISTANCE_WILLING_TO_TRAVEL,ADDRESS,CITY,STATE,ZIPCODE,DISTANCE_ELIGIBLE,PREFERRED_CITY,PREFERRED_STATE,PREFERRED_ZIPCODE,PREFERRED_LANGUAGE) values ('660080','550094300',null,null,25,null,null,null,null,1,'DULLES','VA',20166,'Engish');
    COMMIT;
EOF
    insertRequest(sql)
   end

  def stage_cc_data_apt (friendly_name)
    $today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    $two_days_later = getDateNthDaysFromNow(2, "%m/%d/%Y")
    sql = <<EOF
    Insert into "VARDB"."APPOINTMENT_REQUEST" (APPOINTMENT_REQUEST_ID,PATIENT_ID,LAST_UPDATED_DATE,CREATED_DATE,DELETED_DATE,ACTIVE,SECOND_REQUEST,APPOINTMENT_DATE,APPOINTMENT_TIME,OPTION_DATE_1,OPTION_TIME_1,OPTION_DATE_2,OPTION_TIME_2,OPTION_DATE_3,OPTION_TIME_3,STATUS,APPOINTMENT_TYPE,FACILITY_CODE,EMAIL,PHONE_NUMBER,TEXT_MESSAGING_ALLOWED,TEXT_MESSAGING_PHONE_NUMBER,PURPOSE_OF_VISIT,OTHER_PURPOSE_OF_VISIT,VISIT_TYPE,PROVIDER_ID,PROVIDER_NAME,PROVIDER_PERSON_CLASS,PROVIDER_OPTION,SECOND_REQUEST_SUBMITTED,PARENT_REQUEST_ID,HAS_VETERAN_NEW_MESSAGE,HAS_PROVIDER_NEW_MESSAGE,PROVIDER_SEEN_APPT_REQ,REQUESTED_PHONE_CALL,TYPE_OF_CARE_ID,REASON_FOR_VISIT,OTHER_REASON_FOR_VISIT,ADDITIONAL_INFORMATION,BOOKED_APPT_DATETIME,FRIENDLY_NAME) values ('550094300','#{pw_redacted['edipi']}',to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.29.10.438000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 10.53.11.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,1,0,null,null,'#{getDateNthDaysFromNow(2, "%m/%d/%Y")}','AM','No Date Selected','No Time Selected','No Date Selected','No Time Selected','Submitted','Optometry (routine eye exam)','523','test.email@ablevets.com','(234) 567-8900',0,null,'routine-follow-up',null,'Office Visit','0',null,null,null,0,null,0,1,0,0,'CCOPT',null,null,null,null,'#{friendly_name}');
    INSERT INTO "VARDB"."BEST_TIME_TO_CALL" (APPOINTMENT_REQUEST_ID,BEST_TIME) values ('550094300', 'Morning');
  COMMIT;
EOF
    insertRequest(sql)
  end

  def documentCCRequest (friendly_name)
    $today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    $two_days_later = getDateNthDaysFromNow(2, "%m/%d/%Y")
    sql = <<EOF
    Insert into "VARDB"."APPOINTMENT_REQUEST" (APPOINTMENT_REQUEST_ID,PATIENT_ID,LAST_UPDATED_DATE,CREATED_DATE,DELETED_DATE,ACTIVE,SECOND_REQUEST,APPOINTMENT_DATE,APPOINTMENT_TIME,OPTION_DATE_1,OPTION_TIME_1,OPTION_DATE_2,OPTION_TIME_2,OPTION_DATE_3,OPTION_TIME_3,STATUS,APPOINTMENT_TYPE,FACILITY_CODE,EMAIL,PHONE_NUMBER,TEXT_MESSAGING_ALLOWED,TEXT_MESSAGING_PHONE_NUMBER,PURPOSE_OF_VISIT,OTHER_PURPOSE_OF_VISIT,VISIT_TYPE,PROVIDER_ID,PROVIDER_NAME,PROVIDER_PERSON_CLASS,PROVIDER_OPTION,SECOND_REQUEST_SUBMITTED,PARENT_REQUEST_ID,HAS_VETERAN_NEW_MESSAGE,HAS_PROVIDER_NEW_MESSAGE,PROVIDER_SEEN_APPT_REQ,REQUESTED_PHONE_CALL,TYPE_OF_CARE_ID,REASON_FOR_VISIT,OTHER_REASON_FOR_VISIT,ADDITIONAL_INFORMATION,BOOKED_APPT_DATETIME,FRIENDLY_NAME) values ('550094300','#{pw_redacted['edipi']}',to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.29.10.438000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 10.53.11.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,1,0,'#{getDateNthDaysFromNow(2, "%m/%d/%Y")}','10:53','#{getDateNthDaysFromNow(2, "%m/%d/%Y")}','AM','No Date Selected','No Time Selected','No Date Selected','No Time Selected','Scheduled in Community','Podiatry (routine exam)','523','user@test.com','(222) 222-2222',0,null,'routine-follow-up',null,'Office Visit','0',null,null,null,0,null,0,0,1,0,'CCPOD',null,null,null,'#{getDateNthDaysFromNow(2, "%d-%b-%y")} 10.53.11.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null);
    INSERT INTO "VARDB"."BEST_TIME_TO_CALL" (APPOINTMENT_REQUEST_ID,BEST_TIME) values ('550094300', 'Morning');
    COMMIT;
EOF
    insertRequest(sql)
  end

  def stage_cc_data_reqst_for_PCP()
  sql = <<EOF
  INSERT INTO "VARDB"."CC_APPOINTMENT_REQUEST" (CC_APPOINTMENT_REQUEST_ID,APPOINTMENT_REQUEST_ID,DISTANCE_ELIGIBLE,TRAVEL_BURDEN,UNUSUAL_TRAVEL_BURDEN,DISTANCE_WILLING_TO_TRAVEL,ADDRESS,CITY,STATE,ZIPCODE,PREFERRED_ZIPCODE,PREFERRED_CITY,PREFERRED_STATE,PREFERRED_LANGUAGE) values ('660080','550094301',0,0,0,25,'24664 TRIBE SQ','DULLES','VA','20166','11369','Sterling','VA','English');
  INSERT INTO "VARDB"."OFFICE_HOURS" (CC_APPOINTMENT_REQUEST_ID,OFFICE_TIME) values ('660080', 'Evenings');
  COMMIT;
EOF
  insertRequest(sql)
  end

  def documentCCRequestForPCPInSM (friendly_name)
      $today = getDateNthDaysFromNow(0, "%m/%d/%Y")
      $two_days_later = getDateNthDaysFromNow(2, "%m/%d/%Y")
      sql = <<EOF
      INSERT INTO "VARDB"."APPOINTMENT_REQUEST" (APPOINTMENT_REQUEST_ID, PATIENT_ID, LAST_UPDATED_DATE, CREATED_DATE, ACTIVE, SECOND_REQUEST,OPTION_DATE_1, OPTION_TIME_1, OPTION_DATE_2, OPTION_TIME_2, OPTION_DATE_3, OPTION_TIME_3, STATUS, APPOINTMENT_TYPE, FACILITY_CODE, EMAIL, PHONE_NUMBER, TEXT_MESSAGING_ALLOWED,TEXT_MESSAGING_PHONE_NUMBER, PURPOSE_OF_VISIT, VISIT_TYPE, PROVIDER_ID, SECOND_REQUEST_SUBMITTED, TYPE_OF_CARE_ID, FRIENDLY_NAME, REASON_FOR_VISIT, ADDITIONAL_INFORMATION) values ('550094301', '#{pw_redacted['edipi']}', to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.29.10.438000000 AM', 'DD-MON-RR HH.MI.SSXFF AM'), to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 10.53.11.000000000 AM', 'DD-MON-RR HH.MI.SSXFF AM'), 1, 0, 'No Date Selected', 'No Time Selected', 'No Date Selected', 'No Time Selected', 'No Date Selected', 'No Time Selected', 'Provider Found', 'Primary Care (find a provider)', '523', 'test@yahoo.com', '(234) 567-8900', 0, null, 'routine-follow-up', 'Office Visit', '0', 0, 'CCPCPRVDR', '#{friendly_name}','Find a Primary Care Provider','This is a test by Zulfiqur');
      INSERT INTO "VARDB"."BEST_TIME_TO_CALL" (APPOINTMENT_REQUEST_ID,BEST_TIME) values ('550094301', 'Morning');
      INSERT INTO "VARDB"."PREFERRED_PROVIDER" (PREFERRED_PROVIDER_ID,CC_APPOINTMENT_REQUEST_ID,FIRST_NAME,LAST_NAME,PRACTICE_NAME,PROVIDER_STREET,PROVIDER_CITY,PROVIDER_STATE,PROVIDER_ZIPCODE,PREFERRED_ORDER) values ('2452534','660080','John','Smith','Smiths Care','Test Driver','Manassas','VA','20166',0);
      COMMIT;
EOF
      insertRequest(sql)
  end



  def documentDetailcode
    $today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    $two_days_later = getDateNthDaysFromNow(2, "%m/%d/%Y")
    sql = <<EOF
    INSERT INTO "VARDB"."AR_DETAIL_CODE" (AR_DETAIL_CODE_ID,DETAIL_CODE_ID, APPOINTMENT_REQUEST_ID, CREATED_DATE, USER_ID) values ('8a82828461b511740161bf87d98b001f', 'DETCODE16', '550094300', to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.53.11.000000000 AM', 'DD-MON-RR HH.MI.SSXFF AM'), '990');
    COMMIT;
EOF
    insertRequest(sql)
  end

  def documentDetailcodeForPCPInSM
  $today = getDateNthDaysFromNow(0, "%m/%d/%Y")
  $two_days_later = getDateNthDaysFromNow(2, "%m/%d/%Y")
  sql = <<EOF
    INSERT INTO "VARDB"."AR_DETAIL_CODE" (AR_DETAIL_CODE_ID,DETAIL_CODE_ID, APPOINTMENT_REQUEST_ID, CREATED_DATE, USER_ID) values ('8a82828461b511740161bf87d98b001f', 'DETCODE25', '550094300', to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.53.11.000000000 AM', 'DD-MON-RR HH.MI.SSXFF AM'), '990');
    COMMIT;
EOF
  insertRequest(sql)
  end

  def documentCCintoMongo
    {
        "_id": "550094300",
        "_class": "gov.va.vamf.schedulingmanager.domain.BookCCAppointment",
        "patientIdentifier": {
        "uniqueId": "#{pw_redacted['userid']}",
        "assigningAuthority": "ICN"
        },
        "distanceEligibleConfirmed": true,
        "name": {
            "firstName": "John",
            "lastName": "Smith"
        },
        "providerPractice": "Smith's Care",
        "providerPhone": "(333) 333-4444",
        "address": {
            "street": "24664 Tribe Sq",
            "city": "Dulles",
            "state": "VA",
            "zipCode": "20166"
        },
        "instructionsToVeteran": "Please bring two form of identification",
        "dateTime": $getDaysfromNow,
        "timeZone": "#{getTimeOffset} #{Time.now.zone}"
    }
  end

  def documentPCP_CC_intoMongo
    {
        "_id": "550094301",
        "_class": "gov.va.vamf.schedulingmanager.domain.BookCCAppointment",
        "patientIdentifier": {
        "uniqueId": "#{pw_redacted['userid']}",
        "assigningAuthority": "ICN"
        },
        "distanceEligibleConfirmed": true,
        "name": {
            "firstName": "John",
            "lastName": "Smith"
        },
        "providerPractice": "Smith's Care",
        "providerPhone": "(333) 333-4444",
        "address": {
            "street": "24664 Tribe Sq",
            "city": "Dulles",
            "state": "VA",
            "zipCode": "20166"
        },
        "instructionsToVeteran": "Please bring two form of identification"
    }
  end



  def fillOutDataforCCRequestwithPCP
    @cc_po.communityCare.radio_btn_elements[1].click
    @cc_po.communityCare.eligibility_no_element.click
    @cc_po.communityCare.travel_no_element.click
    @cc_po.communityCare.unusual_no_element.fire_event('onclick')
    @cc_po.communityCare.address_element.when_visible(TIME_OUT_LIMIT)
    @cc_po.communityCare.address = '290 Sharon Rd'
    @cc_po.communityCare.address_element.fire_event('onblur')
    @cc_po.communityCare.city = 'Lakeville'
    @cc_po.communityCare.city_element.fire_event('onblur')
    @cc_po.communityCare.state = 'CT'
    @cc_po.communityCare.state_element.fire_event('onblur')
    @cc_po.communityCare.zip_code_1st_question = '06039'
    @cc_po.communityCare.zip_code_1st_question_element.fire_event('onblur')
    @cc_po.communityCare.find_nearest_facility_element.click
    @cc_po.common.waitWhileSpinnerPresent
    @cc_po.communityCare.continue_btn_element.click
    @cc_po.communityCare.facility_radio_btn_elements[1].click
    @cc_po.communityCare.care_type_element[5].click
    @cc_po.communityCare.con_yes_element.click
    @cc_po.communityCare.continue_btn_element.click
    @cc_po.communityCare.preferred_miles_elements[2].click
    @cc_po.communityCare.preferred_lang = "Chinese"
    @cc_po.communityCare.office_hrs_elements[1].click
    @cc_po.communityCare.add_provider
    @cc_po.communityCare.additional_providerFirstName_elements[0].send_keys("Jhon")
    @cc_po.communityCare.additional_providerLastName_elements[0].send_keys("Smith")
    @cc_po.communityCare.additional_providerPractice_elements[0].send_keys("Smith's Clinic")
    @cc_po.communityCare.additional_providerStreet_elements[0].send_keys("123 Test Drive")
    @cc_po.communityCare.additional_providerCity_elements[0].send_keys("Dulles")
    @cc_po.communityCare.additional_providerState_elements[0].send_keys("VA")
    @cc_po.communityCare.additional_providerZIP_elements[0].send_keys("20109")
    @cc_po.communityCare.continue_btn_element.click
    @cc_po.communityCare.phone_required = '571-477-7211'
    @cc_po.communityCare.phone_required_element.fire_event('onblur')
    @cc_po.communityCare.uncheck_evening_call
    @cc_po.communityCare.phoneCall_requestYes_element.click
    @cc_po.communityCare.email_field = "pcp.test@email.com"
    sleep 3
    @cc_po.communityCare.email_field_element.send_keys :tab
  end

  def fillOutDataforCCRequestwithSpecialityCare
    ninteenDaysLater = getDateNthDaysFromNow(19, "%m/%d/%Y")
    fiveDaysLater = getDateNthDaysFromNow(5,"%m/%d/%Y")
    sevenDaysLater = getDateNthDaysFromNow(7,"%m/%d/%Y")
    @cc_po.communityCare.radio_btn_elements[1].click
    @cc_po.communityCare.eligibility_no_element.click
    @cc_po.communityCare.travel_no_element.click
    @cc_po.communityCare.unusual_no_element.fire_event('onclick')
    @cc_po.communityCare.address_element.when_visible(TIME_OUT_LIMIT)
    @cc_po.communityCare.address = '290 Sharon Rd'
    @cc_po.communityCare.address_element.fire_event('onblur')
    @cc_po.communityCare.city = 'Lakeville'
    @cc_po.communityCare.city_element.fire_event('onblur')
    @cc_po.communityCare.state = 'CT'
    @cc_po.communityCare.state_element.fire_event('onblur')
    @cc_po.communityCare.zip_code_1st_question = '06039'
    @cc_po.communityCare.zip_code_1st_question_element.fire_event('onblur')
    @cc_po.communityCare.find_nearest_facility_element.click
    @cc_po.common.waitWhileSpinnerPresent
    @cc_po.communityCare.continue_btn_element.click
    @cc_po.communityCare.facility_radio_btn_elements[1].click
    @cc_po.communityCare.care_type_element[1].click
    @cc_po.communityCare.con_yes_element.click
    @cc_po.communityCare.continue_btn_element.click
    @cc_po.communityCare.choice1_date = ninteenDaysLater
    @cc_po.communityCare.choice2_date = fiveDaysLater
    @cc_po.communityCare.choice3_date = sevenDaysLater
    @cc_po.communityCare.choice3_date_element.send_keys :tab
    @cc_po.communityCare.previous_btn_element.scroll.to :bottom
    sleep 3
    @cc_po.communityCare.continue_btn_element.click
    @cc_po.communityCare.preferred_miles_elements[2].click
    @cc_po.communityCare.preferred_lang = "Chinese"
    @cc_po.communityCare.office_hrs_elements[1].click
    @cc_po.communityCare.continue_btn_element.click
    @cc_po.communityCare.phone_required = '571-477-7211'
    @cc_po.communityCare.phone_required_element.fire_event('onblur')
    @cc_po.communityCare.uncheck_evening_call
    @cc_po.communityCare.phoneCall_requestYes_element.click
    @cc_po.communityCare.email_field = "test8929@email.com"
    sleep 3
    @cc_po.communityCare.email_field_element.send_keys :tab
  end


  def filloutDataforCCAppointmentRequest(options)
    @cc_po.communityCare.distanceElibleVeteran("Yes")
    @cc_po.communityCare.clickContinueButton
    @cc_po.communityCare.facility_radio_btn_elements[1].click
    @cc_po.communityCare.selectTypeOfCare(options)
    @cc_po.communityCare.con_yes_element.click
    @cc_po.communityCare.clickContinueButton
    @cc_po.communityCare.choice1_date = @fiveDaysLater
    @cc_po.communityCare.choice1_date_element.fire_event('onblur')
    @cc_po.communityCare.continue_btn_element.scroll.to :bottom
    @cc_po.communityCare.clickContinueButton
    @cc_po.communityCare.provider_city = "Dulles"
    @cc_po.communityCare.selectState("VA")
    @cc_po.communityCare.provider_zip = "20166"
    @cc_po.communityCare.selectMiles("50")
    @cc_po.communityCare.selectLanguage("English")
    @cc_po.communityCare.selectOfficeHours("Weekdays")
    @cc_po.communityCare.clickContinueButton
    @cc_po.communityCare.phone_required = 3334445555
    @cc_po.communityCare.email_field= "test.test@gmail.com"
    @cc_po.communityCare.email_field_element.fire_event('onblur')
    @cc_po.communityCare.email_field_element.send_keys :tab
    @cc_po.communityCare.submit_request_element.click
    @cc_po.common.waitWhileSpinnerPresent
    @cc_po.communityCare.app_request_bak_element.scroll.to :top
  end


  def comp_text(expected_content, actual_content)
    expected_content.each_with_index do |expectedScreenRow, i|
      expect(actual_content[i].to_s.strip).to eq(expectedScreenRow.to_s.strip)
    end
  end

  def findCCrequestfromRequestsTable()
    @cc_po.communityCare.request_table_element.scroll.to :bottom
    requests_num = @cc_po.landingAppointments.request_table_list_elements.length
    for i in 0..(requests_num - 1) do
      if  @cc_po.landingAppointments.request_table_list_elements[i].text.include? "CC"
        sleep(2)
        @cc_po.landingAppointments.request_table_list_elements[i].click
        @cc_po.common.waitWhileSpinnerPresent
        break
      else
        puts "Did not find PCP Request in Requests Table"
      end
    end
  end

  def findCCrequestfromAppointmentTable()
    requests_num = @cc_po.landingAppointments.appointment_table_list_elements.length
    for i in 0..(requests_num - 1) do
      if  @cc_po.landingAppointments.appointment_table_list_elements[i].text.include? "Community Care"
        sleep(2)
        @cc_po.landingAppointments.appointment_table_list_elements[i].click
        @cc_po.common.waitWhileSpinnerPresent
        break
      else
        puts "Did not find CC Request in Appointment Table"
      end
    end
  end

def documentCCRequestOracle (requestID, patientID, facility, friendly_name)
    $today = getDateNthDaysFromNow(0, "%m/%d/%Y")
    $two_days_later = getDateNthDaysFromNow(2, "%m/%d/%Y")
    sql = <<EOF
    Insert into "VARDB"."APPOINTMENT_REQUEST" (APPOINTMENT_REQUEST_ID,PATIENT_ID,LAST_UPDATED_DATE,CREATED_DATE,DELETED_DATE,ACTIVE,SECOND_REQUEST,APPOINTMENT_DATE,APPOINTMENT_TIME,OPTION_DATE_1,OPTION_TIME_1,OPTION_DATE_2,OPTION_TIME_2,OPTION_DATE_3,OPTION_TIME_3,STATUS,APPOINTMENT_TYPE,FACILITY_CODE,EMAIL,PHONE_NUMBER,TEXT_MESSAGING_ALLOWED,TEXT_MESSAGING_PHONE_NUMBER,PURPOSE_OF_VISIT,OTHER_PURPOSE_OF_VISIT,VISIT_TYPE,PROVIDER_ID,PROVIDER_NAME,PROVIDER_PERSON_CLASS,PROVIDER_OPTION,SECOND_REQUEST_SUBMITTED,PARENT_REQUEST_ID,HAS_VETERAN_NEW_MESSAGE,HAS_PROVIDER_NEW_MESSAGE,PROVIDER_SEEN_APPT_REQ,REQUESTED_PHONE_CALL,TYPE_OF_CARE_ID,REASON_FOR_VISIT,OTHER_REASON_FOR_VISIT,ADDITIONAL_INFORMATION,BOOKED_APPT_DATETIME,FRIENDLY_NAME) values ('#{requestID}','#{patientID}',to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.29.10.438000000 AM','DD-MON-RR HH.MI.SSXFF AM'),to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 10.53.11.000000000 AM','DD-MON-RR HH.MI.SSXFF AM'),null,1,0,null,null,'#{getDateNthDaysFromNow(2, "%m/%d/%Y")}','AM','No Date Selected','No Time Selected','No Date Selected','No Time Selected','Submitted','Optometry (routine eye exam)','#{facility}','test.email@ablevets.com','(234) 567-8900',0,null,'routine-follow-up',null,'Office Visit','0',null,null,null,0,null,0,1,0,0,'CCOPT',null,null,null,null,'#{friendly_name}');
    INSERT INTO "VARDB"."BEST_TIME_TO_CALL" (APPOINTMENT_REQUEST_ID,BEST_TIME) values ('#{requestID}', 'Morning');
  COMMIT;
EOF
    insertRequest(sql)
end

def documentDetailcodeOracle(detailCodeID, requestID)
  $today = getDateNthDaysFromNow(0, "%m/%d/%Y")
  $two_days_later = getDateNthDaysFromNow(2, "%m/%d/%Y")
  sql = <<EOF
    INSERT INTO "VARDB"."AR_DETAIL_CODE" (AR_DETAIL_CODE_ID,DETAIL_CODE_ID, APPOINTMENT_REQUEST_ID, CREATED_DATE, USER_ID) values ('#{detailCodeID}', 'DETCODE16', '#{requestID}', to_timestamp('#{getDateNthDaysFromNow(0, "%d-%b-%y")} 11.53.11.000000000 AM', 'DD-MON-RR HH.MI.SSXFF AM'), '990');
    COMMIT;
EOF
  insertRequest(sql)
end

def stage_cc_data_reqst_oracle(ccReqID, requestID)
  sql = <<EOF
    Insert into "VARDB"."CC_APPOINTMENT_REQUEST" (CC_APPOINTMENT_REQUEST_ID,APPOINTMENT_REQUEST_ID,TRAVEL_BURDEN,UNUSUAL_TRAVEL_BURDEN,DISTANCE_WILLING_TO_TRAVEL,ADDRESS,CITY,STATE,ZIPCODE,DISTANCE_ELIGIBLE,PREFERRED_CITY,PREFERRED_STATE,PREFERRED_ZIPCODE,PREFERRED_LANGUAGE) values ('#{ccReqID}','#{requestID}',null,null,25,null,null,null,null,1,'DULLES','VA',20166,'Engish');
    COMMIT;
EOF
  insertRequest(sql)
end

def documentRequestInMongo(requestID, userID)
    {
        "_id": "#{requestID}",
        "_class": "gov.va.vamf.schedulingmanager.domain.BookCCAppointment",
        "patientIdentifier": {
            "uniqueId": "#{userID}",
            "assigningAuthority": "ICN"
        },
        "distanceEligibleConfirmed": true,
        "name": {
            "firstName": "John",
            "lastName": "Smith"
        },
        "providerPractice": "Smith's Care",
        "providerPhone": "(333) 333-4444",
        "address": {
            "street": "24664 Tribe Sq",
            "city": "Dulles",
            "state": "VA",
            "zipCode": "20166"
        },
        "instructionsToVeteran": "Please bring two form of identification",
        "dateTime": $getDaysfromNow,
        "timeZone": "#{getTimeOffset} #{Time.now.zone}"
    }
end



